#include<bits/stdc++.h>

using namespace std;

const int N = 1e5 + 10, LOG = 18;
int n, m, q;
vector<int> g[N];
int tin[N], tout[N], timer;
int up[N][LOG];
int dep[N];

bool is_ancestor(int u, int v) { return tin[u] <= tin[v] && tout[u] >= tout[v]; }
int LCA(int u, int v) {
    if(is_ancestor(u, v)) return u;
    if(is_ancestor(v, u)) return v;
    for(int j = LOG - 1; j >= 0; j--) {
        if(up[u][j] == 0) continue;
        if(is_ancestor(up[u][j], v)) continue;
        u = up[u][j];
    }
    return up[u][0];
}

void dfs(int u, int par) {
    tin[u] = ++timer;
    for(int v : g[u]) {
        if(v == par) continue;
        up[v][0] = u;
        dep[v] = dep[u] + 1;
        dfs(v, u);
    }
    tout[u] = ++timer;
}

void Putevi(int _n, int _m, int _q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
    n = _n;
    m = _m;
    q = _q;
    if(m == n - 1) {
        for(int i = 1; i <= m; i++) {
            g[U[i]].push_back(V[i]);
            g[V[i]].push_back(U[i]);
        }
        dfs(1, 0);
        for(int j = 1; j < LOG; j++) for(int i = 1; i <= n; i++) up[i][j] = up[up[i][j - 1]][j - 1];
        for(int i = 1; i <= q; i++) {
            int lca = LCA(X[i], Y[i]);
            Ans[i] = dep[lca] + 1;
        }
        return;
    }
}
/*

5 4 3
1 2 1
2 3 1
2 4 1
1 5 1
1 3
2 3
5 3

*/